<?php
   /**
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Carrello {
        private $db;
        private $id;
        private $idUtente;
        private $gruppoUtente;
        private $idSpedizione;
        private $importoProdotti;
        private $ivaProdotti;
        private $buonoSconto;
        private $valoreBuonoSconto;
        private $importoSpedizione;
        private $importoTotale;
        private $nome;
        private $cognome;
        private $email;
        private $telefono;
        private $nazione;
        private $citta;
        private $indirizzo;
        private $capSpedizione;
        private $codiceFiscale;
        private $partitaIva;
        private $prodottiNelCarrello;
        private $impostazioniEcommerce;

        function __construct($db,$id) {
	    $this->db                = $db;
	    $this->id                = $id;
	    $this->idUtente          = 0;
            $this->gruppoUtente      = 0;
            $this->idSpedizione      = 0;
	    $this->importoProdotti   = 0;
            $this->ivaProdotti    = 0;
            $this->importoSpedizione = 0;
            $this->importoTotale     = 0;
            $this->buonoSconto       = "";
            $this->valoreBuonoSconto = 0;
            $this->nome              = "";
            $this->cognome           = "";
            $this->email             = "";
            $this->telefono          = "";
            $this->nazione           = "";
            $this->citta             = "";
            $this->indirizzo         = "";
            $this->capSpedizione     = "";
            $this->codiceFiscale     = "";
            $this->partitaIva        = "";
            $this->prodottiNelCarrello   = [];
	    $this->impostazioniAdmin      = $this->db->leggiSingolaRiga("geecAd_impostazioni",1);
	    $this->impostazioniEcommerce  = $this->db->leggiSingolaRiga("geecEc_impostazioni",1);
            $this->impostazioniPagamenti = $this->db->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
        }
        
        public function impostaDati($importo, $idUtente, $prodottiNelCarrello) {
	    $this->importoProdotti = $importo;
	    $this->idUtente = $idUtente;
	    $this->prodottiNelCarrello($prodottiNelCarrello);
        }
        
        public function caricaDatiDalDatabase() {
            if($this->id>0) {
                $carrello = $this->db->leggiSingolaRiga("geecEc_carrelli",$this->id);
                $this->importoProdotti   = $carrello["importoProdotti"];
                $this->ivaProdotti    = $carrello["ivaProdotti"];
                $this->importoSpedizione = $carrello["importoSpedizione"];
                $this->importoTotale     = $carrello["importoTotale"];
                $this->idSpedizione      = $carrello["idSpedizione"];
                $this->idUtente          = $carrello["idCliente"];
                $this->buonoSconto       = $carrello["buonoSconto"];
                $this->valoreBuonoSconto = $carrello["valoreBuonoSconto"];
                $this->nazione           = $carrello["nazione"];
            
                $this->caricaProdottiNelCarrello();
            }
        }
        
        /**
         * Popola l'array prodottiNelCarrello con i prodotti presenti in
         * questo carrello. Viene usato anche quando si elimina un prodotto
         * per aggiornare l'array dei prodotti dopo l'eliminazione
         */
        public function caricaProdottiNelCarrello() {
            $this->prodottiNelCarrello = [];
            $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello=".$this->id;
            $risultatoProdottiCarrello = $this->db->eseguiQueryLettura($query);
            while($prodottoOrdinato = $risultatoProdottiCarrello->fetch_assoc()) {
                $this->prodottiNelCarrello[count($this->prodottiNelCarrello)] = $prodottoOrdinato;
            }        
        }
        
        public function crea() {
            $dataCreazione = date("Y-m-d");
            $query = "INSERT INTO geecEc_carrelli VALUES(NULL,'{$this->idUtente}',0,0,0,0,'',0,0,'$this->nome','$this->cognome','$this->nazione','$this->citta','$this->indirizzo','$this->capSpedizione','$this->email','$this->telefono','$this->codiceFiscale','$this->partitaIva','$dataCreazione')";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }

        public function aggiorna() {
            $query = "UPDATE geecEc_carrelli SET importoProdotti=$this->importoProdotti, importoSpedizione=$this->importoSpedizione, importoTotale=$this->importoTotale WHERE id=".$this->id;
            $this->db->eseguiQueryScrittura($query);
        }

        public function aggiornaDatiCliente($nome,$cognome,$telefono,$email,$nazione,$citta,$indirizzo,$cap,$codiceFiscale,$partitaIva) {
            $datiCarrello = $this->db->leggiSingolaRiga("geecEc_carrelli",$this->id);
            $query = "UPDATE geecEc_carrelli SET nome='$nome', cognome='$cognome', telefono='$telefono', email='$email', nazione='$nazione', citta='$citta', indirizzo='$indirizzo', capSpedizione='$cap', codiceFiscale='$codiceFiscale', partitaIva='$partitaIva' WHERE id=".$this->id;
            $this->db->eseguiQueryScrittura($query);
            
            if($nazione!="" && $nazione!=$datiCarrello["nazione"]) {
                $query = "UPDATE geecEc_carrelli SET idSpedizione=0, importoSpedizione=0, importoTotale='$this->importoProdotti' WHERE id=".$this->id;
                $this->db->eseguiQueryScrittura($query);
            }
	}
        
        public function elimina() {
	    /* 
	    	elimino i prodotti nel carrello
	    */
            $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello=".$this->id;
            $risultatoProdottiCarrello = $this->db->eseguiQueryLettura($query);
            while($prodottoOrdinato = $risultatoProdottiCarrello->fetch_assoc()) {
            	$this->db->eseguiQueryCancellazione("geecEc_prodottiOrdinati",$prodottoOrdinato["id"]);
            }
            
            // elimino l'occorrenza del carrello
            $this->db->eseguiQueryCancellazione("geecEc_carrelli",$this->id);
        }

        function determinaLinguaCarrello() {
            $query = "SELECT c.id, c.tipo, c.prezzoUnitario, c.importoTotale, c.attributo, p.immagine, c.quantita, c.nomeProdotto, p.nome, p.lingua FROM geecEc_prodottiOrdinati AS c JOIN geecEc_prodotti AS p ON c.idProdotto=p.id WHERE idCarrello={$this->id} LIMIT 1";
            $ris = $this->db->eseguiQueryLettura($query);
            if($ris->num_rows>0) {
		    $prodotto = $ris->fetch_assoc();
		    return $prodotto["lingua"];
            }
            else { // se non ci sono prodotti restituisce la lingua principale
		    return "italiano";
            }
        }
        
        function stampaCarrello($gestoreTraduzioni,$lingua) {
            if($this->getId()==0) {
                echo"<h2>Il tuo carrello è vuoto</h2>";
            }
            else if(count($this->prodottiNelCarrello)==0) { // se non ci sono prodotti stampa questa frase
                echo"<h2>Il tuo carrello è vuoto</h2>";
            }
            else {
            ?>
                <table id="cart" class="table table-hover table-responsive-lg bg-white">
                    <thead>
                        <tr>
                            <th style="width:50%"><?= $gestoreTraduzioni->traduci("Prodotto",$lingua) ?></th>
                            <th style="width:10%"><?= $gestoreTraduzioni->traduci("Prezzo",$lingua) ?></th>
                            <?php
		                    if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
		                    	?>
		                	<th style="width:13%"><?= $gestoreTraduzioni->traduci("Quantità",$lingua) ?></th>
			               <th style="width:24%" class="text-center"><?= $gestoreTraduzioni->traduci("Subtotale",$lingua) ?></th>
			               <?php
		        	     }
                            ?>
                            <th style="width:15%"></th>
                        </tr>
                    </thead>
            <?php
                    $suffissoIva = ($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA esclusa") ? $gestoreTraduzioni->traduci("+ IVA",$lingua) : "";
                    $query = "SELECT c.id, c.tipo, c.prezzoUnitario, c.importoTotale, c.attributo, p.immagine, c.quantita, c.nomeProdotto, p.nome, p.disponibilita, p.prodottoInesauribile, p.minimoAcquisto FROM geecEc_prodottiOrdinati AS c JOIN geecEc_prodotti AS p ON c.idProdotto=p.id WHERE idCarrello={$this->id}";
                    $ris = $this->db->eseguiQueryLettura($query);
                    while($prodotto = $ris->fetch_assoc()) {
                        $quantitaOrdinabile = ($prodotto["prodottoInesauribile"]=="si" || $prodotto["tipo"]=="prodottoDropshipping") ? 50 : $prodotto["disponibilita"];
                        
                        echo"<tr>
                            <td data-th=\"Prodotto\">
                                <div class=\"media d-flex align-items-center\">
                                    <div class=\"background-image mr-2\" style=\"background:url('{$prodotto["immagine"]}')\">
                                    </div>
                                    <div>
                                        <h5 class=\"mb-0 mr-0\"> {$prodotto["nomeProdotto"]}</h5>
                                        <p class=\"text-truncate\">{$prodotto["attributo"]}</p>
                                     <div>
                                </div>
                            </td>
                            <td data-th=\"Prezzo\" class=\"align-middle\"> € {$prodotto["prezzoUnitario"]} </td>";
                            if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
		                    echo"<td data-th=\"Quantità\" class=\"align-middle\">
		                        <input onchange=\"aggiornaQuantitaProdotto({$prodotto["id"]},{$quantitaOrdinabile},{$prodotto["quantita"]},{$prodotto["minimoAcquisto"]})\" type=\"number\" class=\"form-control small\" id=\"quantita{$prodotto["id"]}\" placeholder=\"1\" value=\"{$prodotto["quantita"]}\" max={$quantitaOrdinabile} maxlength=\"2\" />
		                    </td>
		                    <td data-th=\"Subtotale\"  class=\"text-center align-middle\">
		                        € {$prodotto["importoTotale"]} <small>$suffissoIva</small>
		                    </td>";                     
                            }
                            echo"<td class=\"actions align-middle text-center\">
                                <button class=\"btn btn-light btn-sn\" onClick=\"{location.href='controller/ecommerce/controllerCarrello.php?operazione=eliminaProdotto&idProdotto={$prodotto["id"]}';}\" ><i class=\"far fa-trash-alt\"></i></button>
                            </td>
                        </tr>";
                    }
                    
                // stampo il totale dei prodotti del carrello
                if($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA esclusa") {
                	$this->stampaTotaleProdottiIvaEsclusa($gestoreTraduzioni,$lingua);
                }
                else if($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA inclusa") {
                	$this->stampaTotaleProdottiIvaInclusa($gestoreTraduzioni,$lingua);
                }
                else {
                	$this->stampaTotaleProdottiSenzaCalcoloIva($gestoreTraduzioni,$lingua);
                }
                
                ?>
                </table>
                <?php
            }
	}

	function stampaTotaleProdottiIvaEsclusa($gestoreTraduzioni,$lingua) {
                $totaleProdottiIvaInclusa = $this->importoProdotti + $this->ivaProdotti;
                
                echo"<tr class=\"totale\">";
                	if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td class=\"align-middle\" colspan=\"3\" >".$gestoreTraduzioni->traduci("Subtotale",$lingua)."</td>";
			}
			else {
				echo"<td></td>";
			}
			echo"<td class=\"align-middle text-center\"><strong>€ {$this->importoProdotti}</strong>";
			?>
                         <td class="actions align-middle text-center" >
                         </td>
			</tr>
			<?php
                echo"<tr class=\"totale\">";
                	if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td class=\"align-middle\" colspan=\"3\" >".$gestoreTraduzioni->traduci("IVA",$lingua)."</td>";
			}
			else {
				echo"<td></td>";
			}
			echo"<td class=\"align-middle text-center\"><strong>€ {$this->ivaProdotti}</strong>";
			?>
                         <td class="actions align-middle text-center" >
                         </td>
			</tr>
			<?php
                echo"<tr class=\"totale\">";
                	if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td class=\"align-middle\" colspan=\"3\" >".$gestoreTraduzioni->traduci("Totale",$lingua)."</td>";
			}
			else {
				echo"<td></td>";
			}
			echo"<td class=\"align-middle text-center\"><strong>€ {$totaleProdottiIvaInclusa}</strong> <br><small>".$gestoreTraduzioni->traduci("IVA inclusa",$lingua)."</small>";
			?>
                         <td class="actions align-middle text-center" >
                            <button class="btn btn-outline-primary btn-sm" onclick="{location.href='controller/ecommerce/controllerCarrello.php?operazione=elimina';}" ><?= $gestoreTraduzioni->traduci("Svuota carrello",$lingua) ?></button>
                         </td>
			</tr>
                <?php
	}
	
	function stampaTotaleProdottiIvaInclusa($gestoreTraduzioni,$lingua) {
                $totaleProdottiIvaInclusa = $this->importoProdotti + $this->ivaProdotti;
		?>
                <tr class="totale">
                <?php
                	if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td class=\"align-middle\" colspan=\"3\" >".$gestoreTraduzioni->traduci("Subtotale",$lingua)."</td>";
			}
			else {
				echo"<td></td>";
			}
			echo"<td class=\"align-middle text-center\"><strong>€ {$totaleProdottiIvaInclusa}</strong> <br><small>".$gestoreTraduzioni->traduci("IVA inclusa",$lingua)."</small>";
		?>
			<td class="actions align-middle text-center" >
                            <button class="btn btn-outline-primary btn-sm" onclick="{location.href='controller/ecommerce/controllerCarrello.php?operazione=elimina';}" ><?= $gestoreTraduzioni->traduci("Svuota carrello",$lingua) ?></button>
			</td>
		</tr>
		<?php	
	}
		
	function stampaTotaleProdottiSenzaCalcoloIva($gestoreTraduzioni,$lingua) {
		?>
                <tr class="totale">
                <?php
                	if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td class=\"align-middle\" colspan=\"3\" >".$gestoreTraduzioni->traduci("Subtotale",$lingua)."</td>";
			}
			else {
				echo"<td></td>";
			}
			echo"<td class=\"align-middle text-center\"><strong>€ {$this->importoProdotti}</strong>";
		?>
			<td class="actions align-middle text-center" >
                            <button class="btn btn-outline-primary btn-sm" onclick="{location.href='controller/ecommerce/controllerCarrello.php?operazione=elimina';}" ><?= $gestoreTraduzioni->traduci("Svuota carrello",$lingua) ?></button>
			</td>
		</tr>
		<?php	
	}

        /*
	 *   metodo usato alla conferma dell'ordine per stampare gli acquisti
	 */
        function stampaSommarioCarrello($metodoPagamento,$informazioniSupplementari="") {
            echo"<table id=\"cart\" class=\"table table-hover table-responsive-lg bg-white\">
               <thead>
                    <tr>
                        <th style=\"width:50%\">Prodotto</th>
                        <th style=\"width:13%\">Prezzo</th>";
                        if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
                        	echo"<th style=\"width:13%\">Quantità</th>
	                            <th style=\"width:24%\" class=\"text-center\">Subtotale</th>";
                        }
               echo"</tr>
               </thead>";
            $query = "SELECT c.id, c.prezzoUnitario, c.attributo, c.quantita, c.importoTotale, d.immagine, d.nome FROM geecEc_prodottiOrdinati AS c JOIN geecEc_prodotti AS d ON c.idProdotto=d.id WHERE idCarrello={$this->id}";

            $ris = $this->db->eseguiQueryLettura($query);
                while($prodotto = $ris->fetch_assoc()) {
                    echo"<tr>
                        <td data-th=\"Prodotto\">
                            <div class=\"media d-flex align-items-center\">
                                <div class=\"background-image mr-2\" style=\"background:url('{$prodotto["immagine"]}')\">
                                </div>
                                <h5 class=\"mr-0\"> {$prodotto["nome"]}</h5>
                                <p class=\"text-truncate-3\">{$prodotto["attributo"]}</p>
                            </div>
                        </td>
                        <td data-th=\"Prezzo\" class=\"align-middle\"> € {$prodotto["prezzoUnitario"]}</td>";
                        if($this->impostazioniEcommerce["mostraSelettoreQuantita"]=="si") {
				echo"<td data-th=\"Quantità\" class=\"align-middle\">
		                    <input type=\"text\" class=\"form-control small\" id=\"quantita{$prodotto["id"]}\" placeholder=\"1\" value=\"{$prodotto["quantita"]}\" disabled />
		                </td>
		                <td data-th=\"Subtotale\"  class=\"text-center align-middle\">
		                    <strong>€ {$prodotto["importoTotale"]}</strong>
				</td>";                        
                        }
                    echo"</tr>";
                }

                if($this->idSpedizione!=0) {
                    $queryMetodiSpedizione = "SELECT * FROM geecEc_metodiSpedizione WHERE id=$this->idSpedizione";
                    $risMetodiSpedizione = $this->db->eseguiQueryLettura($queryMetodiSpedizione);
                    $metodoSpedizione = $risMetodiSpedizione->fetch_assoc();
                    $SpedizioneScelta = $metodoSpedizione["nome"];
                    
                    echo"<tr>
                        <td colspan=\"4\"><p class=\"mb-0\">Tipo di spedizione:</p> <h5>$SpedizioneScelta</h5></td>
                    </tr>";
                }

                echo"<tr>
                        <td colspan=\"4\"><p class=\"mb-0\">Metodo di pagamento:</p> <h5>".ucfirst($metodoPagamento)."</h5></td>
                    </tr>
                    <tr>
                        <td colspan=\"4\"><p class=\"mb-0\">$informazioniSupplementari</p></td>
                    </tr>
                </table>
                <hr>
                <div class=\"row\">
                    <div class=\"col\">
                        <div class=\"float-right\">
                            <h3 class=\"accent\">Totale: € $this->importoTotale</h3>
                        </div>
                    </div>
                </div>";

	}
        
        function aggiornaImportoCarrello() {
	    $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);

	    $importo = 0;
	    $ivaProdotti = 0;
	    while($item = $ris->fetch_assoc()) {
		$totaleSingoloProdotto = $item["prezzoUnitario"] * $item["quantita"];
		$importo += $totaleSingoloProdotto;
		$ivaProdotti += $item["ivaProdottoUnitario"] * $item["quantita"];
	    }
            $this->importoProdotti = $importo;
	    $this->importoTotale = $importo + $ivaProdotti + $this->importoSpedizione;

            $this->valoreBuonoSconto = 0; // valore buono sconto inizializzato a 0
	    if($this->buonoSconto!="") {
     		$buonoSconto = $this->db->leggiSingolaRiga("geecEc_buoniSconto",$this->buonoSconto,"codice");
		// calcolo del valore di sconto
                if($buonoSconto["tipo"]=="percentuale di sconto") {
                    $this->valoreBuonoSconto = ($this->importoProdotti * $buonoSconto["ammontareSconto"]) / 100;
                }
                else {
                    $this->valoreBuonoSconto = $buonoSconto["ammontareSconto"];
                }
	    }
	    $this->importoTotale -= $this->valoreBuonoSconto;
            
	    if($this->importoTotale <= 0) { // il totale non può essere negativo, se il buono supera il valore dello sconto il totale sarà 0
	    	$this->importoTotale = 0;
	    }
	    $queryAggiornamentoQuantita = "UPDATE geecEc_carrelli SET importoProdotti=$importo, importoSpedizione=$this->importoSpedizione, ivaProdotti=$ivaProdotti, importoTotale={$this->importoTotale}, valoreBuonoSconto='{$this->valoreBuonoSconto}' WHERE id={$this->id}";
            $this->db->eseguiQueryScrittura($queryAggiornamentoQuantita);
	}
        
        /**
         *  Controlla se l'importo del carrello soddisfa i requisi minimi della spedizione attuale,
         *  in caso negativo azzera la spedizione in modo che quando l'utente ricaricherà la pagina
         *  del carrello si ritroverà assegnata una spedizione adatta
         *
         *  NB questo metodo va invocato quando i dati del carrello sono aggiornati, ad esempio dopo
         *  caricaDatiDalDatabase() oppure dopo aggiornaImportoCarrello()
         */
        function controllaValiditaSpedizione() {
            if($this->idSpedizione!=0) {
                $datiMetodoSpedizioneAttuale = $this->db->leggiSingolaRiga("geecEc_metodiSpedizione",$this->idSpedizione);
                $importoRealeProdotti = $this->importoProdotti - $this->valoreBuonoSconto;
                
                if($datiMetodoSpedizioneAttuale["importoMinimoCarrello"]> $importoRealeProdotti) {
                    $queryAggiornamentoQuantita = "UPDATE geecEc_carrelli SET idSpedizione=0, importoSpedizione=0, importoTotale={$importoRealeProdotti} WHERE id={$this->id}";
                    $this->db->eseguiQueryScrittura($queryAggiornamentoQuantita);
                }
            }
        }
        
        public function inserisciBuonoSconto($buonoSconto) {
            $datiBuonoSconto = $this->db->leggiSingolaRiga("geecEc_buoniSconto",$buonoSconto,"codice");
            if($datiBuonoSconto) {
                $dataOggi      = strtotime(date("Y-m-d"));
                $scadenzaBuono = strtotime($datiBuonoSconto["dataScadenza"]);
            
                $this->buonoSconto = $datiBuonoSconto["codice"];
                // calcolo del valore di sconto
                if($datiBuonoSconto["tipo"]=="percentuale di sconto") {
                    $valoreBuonoSconto = ($this->importoProdotti * $datiBuonoSconto["ammontareSconto"]) / 100;
                }
                else {
                    $valoreBuonoSconto = $datiBuonoSconto["ammontareSconto"];
                }

                // verifico la presenza nel carrello di prodotti di un'eventuale categoria (o sottocategories) impostata nel buono sconto
                $prodottiNelCarrelloCategoriaIndicata = 0;
                if($datiBuonoSconto["categoria"]>0) {
                    $idCategorieAmmesse = recuperaIdSottoCategorie($this->db, "ecommerce", $datiBuonoSconto["categoria"]);
                    $idCategorieAmmesse[count($idCategorieAmmesse)] = $datiBuonoSconto["categoria"];
                    $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello=".$this->id;
                    $risultatoProdottiCarrello = $this->db->eseguiQueryLettura($query);
                    while($prodottoOrdinato = $risultatoProdottiCarrello->fetch_assoc()) {
                        $datiProdottoOrdinato = $this->db->leggiSingolaRiga("geecEc_prodotti",$prodottoOrdinato["idProdotto"]);
                        if(in_array($datiProdottoOrdinato["categoria"], $idCategorieAmmesse)) {
                            $prodottiNelCarrelloCategoriaIndicata ++;
                            break;
                        }
                    }
                }
                        
                if($scadenzaBuono<$dataOggi) {
                    return "Questo buono è scaduto";
                }
                else if($datiBuonoSconto["prodotto"]>0 && $this->db->contaRigheTabella("geecEc_prodottiOrdinati",array("idCarrello"=>$this->id,"idProdotto"=>$datiBuonoSconto["prodotto"]))==0) {
                    $datiProdotto = $this->db->leggiSingolaRiga("geecEc_prodotti",$datiBuonoSconto["prodotto"]);
                    return "Per usare questo buono devi avere nel carrello questo prodotto: {$datiProdotto["nome"]}";
                }
                else if($datiBuonoSconto["categoria"]>0 && $prodottiNelCarrelloCategoriaIndicata==0) {
                    
                    $datiCategoria = $this->db->leggiSingolaRiga("geec_categorie",$datiBuonoSconto["categoria"]);
                    return "Per usare questo buono devi avere nel carrello un prodotto della categoria {$datiCategoria["nome"]}";
                }
                else if($this->importoProdotti>=$datiBuonoSconto["spesaMinima"]) { // per accedere alla scontistica contano solo i costi del prodotto non della spedizione
                    $queryBuonoSconto = "UPDATE geecEc_carrelli SET buonoSconto='{$datiBuonoSconto["codice"]}', valoreBuonoSconto='$valoreBuonoSconto' WHERE id=".$this->id;
                    $this->db->eseguiQueryScrittura($queryBuonoSconto);
                    $this->aggiornaImportoCarrello();
                    $this->controllaValiditaSpedizione();
                    return "ok";
                }
                else {
                    return "L'importo del tuo carrello non è sufficiente per poter usare questo buono sconto";
                }
	     }
	     else {
		return "Il buono che hai inserito non esiste!";
	     }
        }
        
       /*
	*  metodo usato alla conferma dell'ordine per prendere le informazioni da inserire
        *  nell'email di conferma
	*/
        function stampaSommarioCarrelloPerEmail() {
            $query = "SELECT c.id, c.prezzoUnitario,  c.attributo, c.importoTotale, c.quantita, d.immagine, d.nome, d.categoria FROM geecEc_prodottiOrdinati AS c JOIN geecEc_prodotti AS d ON c.idProdotto=d.id WHERE idCarrello={$this->id}";

            $elencoProdotti = "<table>"
                    . "<thead>"
                    . "<tr>"
                    . "<th class=\"align-left\" style=\"padding-left:0\">Prodotto</th>"
                    . "<th class=\"align-left\" style=\"padding-left:0\">Categoria</th>"
                    . "<th class=\"align-left\" style=\"padding-left:0\">Quantità</th>"
                    . "<th class=\"align-left\" style=\"padding-left:0\">Costo unitario </th>"
                    . "<th class=\"align-left\" style=\"padding-left:0\">Totale parziale</th>"
                    . "</tr>"
                    . "</thead>"
                    . "<tbody>";
            $ris = $this->db->eseguiQueryLettura($query);
            while($prodotto = $ris->fetch_assoc()) {
		$categoria = ($prodotto["categoria"]>0) ? $this->db->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]) : ["nome" => " - "];
		$elencoProdotti .= "<tr> <td>{$prodotto["nome"]} {$prodotto["attributo"]}</td><td>{$categoria["nome"]}</td><td>{$prodotto["quantita"]}</td><td> {$prodotto["prezzoUnitario"]} €</td><td>{$prodotto["importoTotale"]} €</td></tr>";
            }
            $elencoProdotti .="</tbody></table>";
            return $elencoProdotti;
	}
        
        function convertiInOrdine($nome,$cognome,$via,$citta,$capSpedizione,$email,$telefono,$spedizione,$tipoPagamento,$codiceFiscale,$partitaIva,$tipoRicevuta) {
            $data = date("Y-m-d H:i");
            if($spedizione==0) {
               $datiSpedizioni["nome"] = "Ritiro in sede";
            }
            else {
               $datiSpedizioni = $this->db->leggiSingolaRiga("geecEc_metodiSpedizione",$spedizione);
            }
            
            if($tipoPagamento == "Pagamento alla consegna") {
                $statoOrdine = "Da spedire con pagamento alla consegna";
                $this->setImportoTotale($this->getImportoTotale() + $this->impostazioniPagamenti["costoPagamentoConsegna"]);
                $queryAggiornamentoTotale = "UPDATE geecEc_carrelli SET ivaProdotti = ivaProdotti+ {$this->impostazioniPagamenti["costoPagamentoConsegna"]}, importoTotale = importoTotale+ {$this->impostazioniPagamenti["costoPagamentoConsegna"]} WHERE id = $this->id";
                $this->db->eseguiQueryScrittura($queryAggiornamentoTotale);
            }
            else {
                $statoOrdine = "In attesa di pagamento";
            }
            
	    $queryOrdine = "INSERT INTO geecEc_ordini VALUES(NULL,".$this->idUtente.",{$_SESSION["carrello"]},'','$statoOrdine','','$nome $cognome','$via','$citta','$capSpedizione','','$email','$telefono','{$datiSpedizioni["nome"]}','$tipoPagamento','$partitaIva','$codiceFiscale','$tipoRicevuta',{$this->getImportoTotale()},'$data')";
            
            // controlla per ogni prodotto acquistato se è un prodotto di tipo abbonamento, in tal caso viene creato
            foreach($this->prodottiNelCarrello as $prodottoNelCarrello) {
                $datiProdottoOrdinato = $this->db->leggiSingolaRiga("geecEc_prodotti",$prodottoNelCarrello["idProdotto"]);
                $dataAnnoDopo = date('Y-m-d', strtotime('+1 year', strtotime($data)));
                if($datiProdottoOrdinato["tipoProdotto"]=="abbonamento") {
                    $queryInserimentoAbbonamento = "INSERT INTO geecEc_abbonamenti VALUES(NULL,".$this->idUtente.",{$datiProdottoOrdinato["id"]},'{$datiProdottoOrdinato["attributo"]}','in attesa di pagamento','','$nome $cognome','$via','$citta','$capSpedizione','$email','$telefono','{$datiSpedizioni["nome"]}','$tipoPagamento','$tipoRicevuta',{$this->getImportoTotale()},'$data','$dataAnnoDopo')";
                    $this->db->eseguiQueryCreazione($queryInserimentoAbbonamento);
                }
            }
            
            // creo documento di fatturazione (se la contabilità di Geecom Admin è attiva)
            if($this->impostazioniAdmin["attivaContabilita"] == "si" && $this->impostazioniEcommerce["documentoFiscale"]=="ricevuta") {
                $query = "SELECT * FROM geecAd_documentiContabili WHERE tipo LIKE 'ricevuta' ORDER BY id DESC";
                $ris   = $this->db->eseguiQueryLettura($query);
                $ultimaRicevuta = $ris->fetch_assoc();

                $progressivo = $ultimaRicevuta["numero"] +1;
                $queryInserimentoAbbonamento = "INSERT INTO geecAd_documentiContabili VALUES(NULL,$progressivo,$this->idUtente,'ricevuta','inviata','',{$this->getImportoTotale()})";
                $this->db->eseguiQueryCreazione($queryInserimentoAbbonamento);
            }
            else if($this->impostazioniAdmin["attivaContabilita"] == "si" && $this->impostazioniEcommerce["documentoFiscale"]=="fattura") {
                $query = "SELECT * FROM geecAd_documentiContabili WHERE tipo LIKE 'fattura' ORDER BY id DESC";
                $ris   = $this->db->eseguiQueryLettura($query);
                $ultimaFattura = $ris->fetch_assoc();

                $progressivo = $ultimaFattura["numero"] +1;
                $queryInserimentoAbbonamento = "INSERT INTO geecAd_documentiContabili VALUES(NULL,$progressivo,$this->idUtente,'fattura','inviata','',{$this->getImportoTotale()})";
                $this->db->eseguiQueryCreazione($queryInserimentoAbbonamento);
            }
            
            return $this->db->eseguiQueryCreazione($queryOrdine);
        }

        /*
	 *  Questo metodo viene chiamato dal metodo convertiInOrdine per 
	 *  aggiornare le disponibilità dopo che un ordine è stato convalidato
	 */
	function aggiornaDisponibilitaNegozio() {
            $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);

            $peso = 0;
            while($prodotto = $ris->fetch_assoc()) {
                $query = "UPDATE geecEc_prodotti SET disponibilita=disponibilita-{$prodotto["quantita"]}, numeroVendite=numeroVendite+{$prodotto["quantita"]} WHERE id={$prodotto["idProdotto"]}";
                $this->db->eseguiQueryScrittura($query);
            }
	}
        
        /*
	 *  Questo metodo viene chiamato quando un ordine viene annullato per 
	 *  ripristinare le disponibilità precedentemente scalate
	 */
	function ripristinaDisponibilitaNegozio() {
            $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);

            $peso = 0;
            while($prodotto = $ris->fetch_assoc()) {
                $query = "UPDATE geecEc_prodotti SET disponibilita=disponibilita+{$prodotto["quantita"]}, numeroVendite=numeroVendite-{$prodotto["quantita"]} WHERE id={$prodotto["idProdotto"]}";
                $this->db->eseguiQueryScrittura($query);
            }
        }
        
	function printJavascriptFunctionUpdate() {
            echo"function aggiornaQuantita(id) {
                var q =$(\"#quantita\"+id).val();
                location.href='classes/cart/cartController.php?operationType=updateCartProduct&idProduct='+id+'&productQuantity='+q+'&company={$this->companyId}';
            }";
	}

	function updateProductCart($product,$quantity) {
	    $query = "UPDATE geecEc_prodottiOrdinati SET quantity=$quantity WHERE idCarrello=".$this->id." AND idItem=$product";
	    $this->db->eseguiQueryScrittura($query);
	    $this->aggiornaImportoCarrello();
	}

	function incrementaQuantitaProdotto($idProdotto,$quantita) {
	    $query = "UPDATE geecEc_prodottiOrdinati SET quantita=quantita+$quantita WHERE idCarrello=".$this->id." AND idProdotto=$idProdotto";
            $this->db->eseguiQueryScrittura($query);

	    $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello=".$this->id." AND idProdotto=$idProdotto";
            $ris = $this->db->eseguiQueryLettura($query);
	    $prodotto = $ris->fetch_assoc();
	    $totaleSingoloProdotto = ($prodotto["prezzoUnitario"] + $prodotto["ivaProdottoUnitario"]) * $prodotto["quantita"];
	    
	    $query = "UPDATE geecEc_prodottiOrdinati SET importoTotale=$totaleSingoloProdotto WHERE idCarrello=".$this->id." AND idProdotto=$idProdotto";

	    $this->db->eseguiQueryScrittura($query);
	    $this->aggiornaImportoCarrello();
	}

        function aggiungiProdottoAlCarrello($prodotto,$idVariazione,$quantita,$attributo) {
            if($this->gruppoUtente!=0) {
                $datiGruppo = $this->db->leggiSingolaRiga("geec_gruppi",$this->gruppoUtente);
            }
            else {
                $datiGruppo = null;
            }
                
	    $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);
	    $found = false;

	    while($item = $ris->fetch_assoc()) {
		if($item["idProdotto"]==$prodotto) {
                    $this->incrementaQuantitaProdotto($prodotto,$quantita);
                    $found = true;
		}
	    }
	    if(!$found) {
                $datiProdotto  = $this->db->leggiSingolaRiga("geecEc_prodotti",$prodotto);
                $nomeProdotto  = filter_var($datiProdotto["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $ivaProdotto   = ($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA esclusa") ? ($datiProdotto["prezzo"] * $datiProdotto["iva"] / 100) : 0;
                $prezzoBase    = $datiProdotto["prezzo"];
                if($idVariazione==0) {
                    $prezzoBase    = ($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA inclusa") ? $datiProdotto["prezzo"] + ($datiProdotto["prezzo"] * $datiProdotto["iva"] / 100) : $datiProdotto["prezzo"];
                    $prezzoOfferta = ($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA inclusa") ? $datiProdotto["prezzoOfferta"] + ($datiProdotto["prezzoOfferta"] * $datiProdotto["iva"] / 100) : $datiProdotto["prezzoOfferta"];
	    	}
	    	else {
                    $datiVariazione = $this->db->leggiSingolaRiga("geecEc_variazioniProdotto ",$idVariazione);
                    $nomeProdotto   = $nomeProdotto."<br>".filter_var($datiVariazione["nome"],FILTER_SANITIZE_STRING);
                    $prezzoBase	= $datiVariazione["costo"];
                    $prezzoOfferta = 0;
	    	}
                
                if($datiGruppo != null) {
                    $prezzoBase    = round($prezzoBase - ($prezzoBase * $datiGruppo["percentualeSconto"] / 100),2);
                    $prezzoOfferta = ($prezzoOfferta!=0) ? round($prezzoOfferta - ($prezzoOfferta * $datiGruppo["percentualeSconto"] / 100),2) : 0;
                }
                
                /*
                 * Se il prodotto è in offerta il prezzo unitario inserito sarà quello presente nel campo
                 * prezzoOfferta, altrimenti la variabile $prezzoAttualeProdotto sarà inizializzata con
                 * il valore del campo prezzo
                 */
                if($datiProdotto["prezzoOfferta"]!=0) {
                    $prezzoAttualeProdotto = $prezzoOfferta;
                }
                else {
                    $prezzoAttualeProdotto = $prezzoBase;
                }
                
                $importoTotaleProdotto = ($this->impostazioniEcommerce["aggiungiIvaProdotti"]=="si" && $this->impostazioniEcommerce["mostraIvaPrezziCarrello"]=="IVA inclusa") ? ($prezzoAttualeProdotto + $ivaProdotto) * $quantita : $prezzoAttualeProdotto * $quantita;
		$query = "INSERT INTO geecEc_prodottiOrdinati VALUES(NULL,'prodottoEcommerce',".$this->id.",$prodotto,$idVariazione,$quantita,'$nomeProdotto','$attributo',$prezzoAttualeProdotto,$ivaProdotto,$importoTotaleProdotto,0,0)";
		$this->db->eseguiQueryScrittura($query);
	    }
	    $this->aggiornaImportoCarrello();
        }

        /*
         * Questo metodo deve essere usato quando si vuole inserire nel carrello un prodotto non presente
         * nel database del sito, ma preso in dropshipping
         */
        function aggiungiProdottoDropshippingAlCarrello($prodotto,$nomeProdotto,$quantita,$attributo,$prezzo) {
            if($this->gruppoUtente!=0) {
                $datiGruppo = $this->db->leggiSingolaRiga("geecAd_gruppi",$this->gruppoUtente);
            }
            else {
                $datiGruppo = null;
            }
                
	    $query = "SELECT * FROM geecEc_prodottiOrdinati WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);
	    $found = false;

	    while($item = $ris->fetch_assoc()) {
		if($item["idProdotto"]==$prodotto) {
                    $this->incrementaQuantitaProdotto($prodotto,$quantita);
                    $found = true;
		}
	    }
	    if(!$found) {
                $importoTotaleProdotto = $prezzo * $quantita;
		$query = "INSERT INTO geecEc_prodottiOrdinati VALUES(NULL,'prodottoDropshipping',".$this->id.",$prodotto,0,0,$quantita,'$nomeProdotto','$attributo',$prezzoAttualeProdotto,$importoTotaleProdotto,0,0)";
		$this->db->eseguiQueryScrittura($query);
	    }
	    $this->aggiornaImportoCarrello();
        }
        
        function modificaQuantitaProdotto($idProdotto,$quantita) {
	    $query = "UPDATE geecEc_prodottiOrdinati SET quantita=$quantita WHERE id=$idProdotto";
            $this->db->eseguiQueryScrittura($query);
	    
            $prodotto = $this->db->leggiSingolaRiga("geecEc_prodottiOrdinati",$idProdotto);
	    $totaleSingoloProdotto = $prodotto["prezzoUnitario"] * $quantita;
	    $queryAggiornamentoProdotto = "UPDATE geecEc_prodottiOrdinati SET importoTotale=$totaleSingoloProdotto WHERE id={$idProdotto}";
	    $this->db->eseguiQueryScrittura($queryAggiornamentoProdotto);
	    $this->aggiornaImportoCarrello();
	    $this->controllaValiditaSpedizione();
        }
        
        function aggiornaCostoSpedizione() {
            $peso = $this->calcolaPesoProdottiNelCarrello();
            $spedizione = $this->db->leggiSingolaRiga("geecEc_metodiSpedizione",$this->idSpedizione);
            
            $queryCostoSpedizione = "SELECT * FROM geecEc_fascePrezzoSpedizione WHERE idSpedizione=$this->idSpedizione AND pesoMinimo<=$peso AND pesoMassimo>$peso LIMIT 1";
            $risCostoSpedizione = $this->db->eseguiQueryLettura($queryCostoSpedizione);
            if($risCostoSpedizione->num_rows>0) {
                $datiSpedizione = $risCostoSpedizione->fetch_assoc();
                 
                if(capInZonaDisagiata($this->db,$this->capSpedizione)) {  
                    $costoSpedizione = $datiSpedizione["costoZoneDisagiate"];
                }
                else {
                    $costoSpedizione = $datiSpedizione["costo"];
                }
            }
            else {
                if(capInZonaDisagiata($this->db,$this->capSpedizione)) {          
                    $costoSpedizione = $spedizione["costoZoneDisagiate"];
                }
                else {
                    $costoSpedizione = $spedizione["costo"];
                }
            }
            
            $this->setImportoSpedizione($costoSpedizione);
            $this->db->eseguiQueryScrittura("UPDATE geecEc_carrelli SET importoSpedizione={$costoSpedizione} WHERE id=$this->id");
            $this->aggiornaImportoCarrello();
        }
        
        function modificaSpedizione($idSpedizione) {
            $peso = $this->calcolaPesoProdottiNelCarrello();
            $spedizione = $this->db->leggiSingolaRiga("geecEc_metodiSpedizione",$idSpedizione);
            
            $queryCostoSpedizione = "SELECT costo FROM geecEc_fascePrezzoSpedizione WHERE idSpedizione=$idSpedizione AND pesoMinimo<=$peso AND pesoMassimo>$peso LIMIT 1";
            $risCostoSpedizione = $this->db->eseguiQueryLettura($queryCostoSpedizione);
            if($risCostoSpedizione->num_rows>0) {
                 $risCosto = $risCostoSpedizione->fetch_array(MYSQLI_NUM);
                 $costo = $risCosto[0];
                 $this->setImportoSpedizione($costo);
            }
            else {
                 $this->setImportoSpedizione($spedizione["costo"]);
            }
            
            $this->db->eseguiQueryScrittura("UPDATE geecEc_carrelli SET idSpedizione=$idSpedizione, importoSpedizione={$spedizione["costo"]} WHERE id=$this->id");
            $this->aggiornaImportoCarrello();
        }

        /*
         * metodo usato quando viene registrato un nuovo utente e deve essere associato al carrello
         */
        function associaCarrelloUtente($idCliente) {
            $this->db->eseguiQueryScrittura("UPDATE geecEc_carrelli SET idCliente=$idCliente WHERE id=$this->id");
        }
        
        public function eliminaProdottoDalCarrello($prodotto) {
            $queryEliminazioneOggetto = "DELETE FROM geecEc_prodottiOrdinati WHERE id=".$prodotto;
            $this->db->eseguiQueryScrittura($queryEliminazioneOggetto);
            $this->aggiornaImportoCarrello();
            $this->controllaValiditaSpedizione();
            
            // aggiorna la variabile prodottiNelCarrello con i prodotti attuali
            $this->caricaProdottiNelCarrello();
        }

        function calcolaPesoProdottiNelCarrello() {
            $query = "SELECT * FROM geecEc_prodottiOrdinati AS po "
                    . "JOIN geecEc_prodotti AS p ON po.idProdotto = p.id "
                    . "WHERE idCarrello={$this->id}";
            $ris = $this->db->eseguiQueryLettura($query);

	    $peso = 0;
	    while($prodotto = $ris->fetch_assoc()) {
                $pesoProdotto = ($prodotto["peso"]>$prodotto["pesoVolumetrico"]) ? $prodotto["peso"] : $prodotto["pesoVolumetrico"];
		$peso += ($pesoProdotto * $prodotto["quantita"]);
	    }
	    return $peso;
        }
        
	public function getNumeroProdotti() {
            return count($this->prodottiNelCarrello);
	}

        public function getDb() {
            return $this->db;
	}
        
	public function getId() {
            return $this->id;
	}

	public function setIdUtente($idUtente) {
            $this->idUtente = $idUtente;
	}

	public function getImportoProdotti() {
            return $this->importoProdotti;
	}
        
        public function getImportoSpedizione() {
            return $this->importoSpedizione;
        }

        public function getImportoTotale() {
            return $this->importoTotale;
        }

        public function getProdottiNelCarrello() {
            return $this->prodottiNelCarrello;
        }
        public function getGruppoUtente() {
            return $this->gruppoUtente;
        }

        public function getBuonoSconto() {
            return $this->buonoSconto;
        }

        public function getValoreBuonoSconto() {
            return $this->valoreBuonoSconto;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getCognome() {
            return $this->cognome;
        }

        public function getEmail() {
            return $this->email;
        }

        public function getTelefono() {
            return $this->telefono;
        }

        public function getNazione() {
            return $this->nazione;
        }
        
        public function setGruppoUtente($gruppoUtente) {
            $this->gruppoUtente = $gruppoUtente;
        }

        public function setBuonoSconto($buonoSconto) {
            $this->buonoSconto = $buonoSconto;
        }

        public function setValoreBuonoSconto($valoreBuonoSconto) {
            $this->valoreBuonoSconto = $valoreBuonoSconto;
        }

        public function setImportoSpedizione($importoSpedizione) {
            $this->importoSpedizione = $importoSpedizione;
        }

        public function setImportoTotale($importoTotale) {
            $this->importoTotale = $importoTotale;
        }

        public function setProdottiNelCarrello($prodottiNelCarrello) {
            $this->prodottiNelCarrello = $prodottiNelCarrello;
        }
        
        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setCognome($cognome) {
            $this->cognome = $cognome;
        }

        public function setEmail($email) {
            $this->email = $email;
        }

        public function setTelefono($telefono) {
            $this->telefono = $telefono;
        }
        
        public function setCapSpedizione($capSpedizione) {
            $this->capSpedizione = $capSpedizione;
        }
        
        public function setNazione($nazione) {
            $this->nazione = $nazione;
        }
    }
